/*====================================================================*
 *   
 *   Copyright (c) 2011, 2012, Qualcomm Atheros Communications Inc.
 *   
 *   Permission to use, copy, modify, and/or distribute this software 
 *   for any purpose with or without fee is hereby granted, provided 
 *   that the above copyright notice and this permission notice appear 
 *   in all copies.
 *   
 *   THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL 
 *   WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED 
 *   WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL  
 *   THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR 
 *   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 *   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 *   NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 *   CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *   
 *--------------------------------------------------------------------*/

/*====================================================================*
 *   
 *   qca_ar7k.h
 *
 *   Qualcomm Atheros UART register definition.
 *
 *   This module is designed to define the Qualcomm Atheros UART register 
 *   placeholders;
 *
 *--------------------------------------------------------------------*/

#ifndef QCA_UART_HEADER
#define QCA_UART_HEADER

/*====================================================================*
 *   system header files;
 *--------------------------------------------------------------------*/

#include <linux/sched.h>
#include <linux/types.h>
#include <linux/skbuff.h>
#include <linux/tty.h>
#include <linux/netdevice.h>

/*====================================================================*
 *   custom header files;
 *--------------------------------------------------------------------*/

#include "qca_framing.h"

/*====================================================================*
 *   driver variables;
 *--------------------------------------------------------------------*/

struct qcauart {
	struct net_device *dev;
	struct net_device_stats stats;

	struct tty_struct *tty;

	QcaFrmHdl lFrmHdl;

	struct sk_buff *rx_skb;
	struct sk_buff *tx_skb;
};

/*====================================================================*
 *
 *--------------------------------------------------------------------*/

#endif 
